/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserView;
import org.eclipse.ui.part.WorkbenchPart;
import org.osgi.framework.Bundle;

public class GithubNetworkHandler
extends AbstractGitHandler {
    private static final String GITHUB_JS = "templates/github.js";
    private String fgGithubJS;

    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        String networkURL = this.getGithubURL();
        if (networkURL == null) {
            return null;
        }
        try {
            String browserViewerFieldName = "viewer";
            Class<WebBrowserView> klass = WebBrowserView.class;
            IViewPart obj = this.getActivePage().showView("org.eclipse.ui.browser.view", "-0", 2);
            try {
                Method m = WorkbenchPart.class.getDeclaredMethod("setPartName", String.class);
                m.setAccessible(true);
                m.invoke((Object)obj, Messages.GithubNetworkHandler_ViewName);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
            try {
                Field f = klass.getDeclaredField("viewer");
                f.setAccessible(true);
                final BrowserViewer viewer = (BrowserViewer)f.get(obj);
                viewer.getBrowser().addProgressListener(new ProgressListener(){

                    public void completed(ProgressEvent event) {
                        String js = GithubNetworkHandler.this.getGithubJS();
                        viewer.getBrowser().execute(js);
                    }

                    public void changed(ProgressEvent event) {
                    }
                });
                viewer.setURL(networkURL);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        return null;
    }

    private String getGithubURL() {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        Set urls = repo.getGithubURLs();
        if (!urls.isEmpty()) {
            return String.valueOf((String)urls.iterator().next()) + "/network";
        }
        return null;
    }

    protected boolean calculateEnabled() {
        return this.getGithubURL() != null;
    }

    protected synchronized String getGithubJS() {
        if (this.fgGithubJS == null) {
            try {
                InputStream stream = FileLocator.openStream((Bundle)GitUIPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)GITHUB_JS), (boolean)false);
                this.fgGithubJS = IOUtil.read((InputStream)stream);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
        }
        return this.fgGithubJS;
    }
}

